'This assumes the System I2C has been configured to use GP2 and GP3
'by using the OPTION SYSTEM I2C GP2, GP3, SLOW command
'The system I2C bus is referenced as I2C2 in programs, as GP2 and GP3 are
'tied to I2C2 identities
'Addresses of some known modules have been singled out

SetPin gp0,gp1,i2c
I2C open 100,1000
For n = 0 To 127
  I2C check n
  If MM.I2C = 0 Then
    Print "I2C Addr: "; n; " present"
  End If
  Pause 10
Next n

'If the system I2C bus has not already been OPTION'd, use these to enable I2C2
'SetPin gp2,gp3,i2c2
'I2C2 open 100,1000

For n = 0 To 127

  I2C2 check n
  If MM.I2C = 0 Then
    select case n
      case 32
        print "I2C2 addr: 32 PCF8575 DIO expander present"
        
      case 48
        print "I2C2 addr: 48 NEO Slider present"

      case 52
        print "I2C2 addr: 52 TCA8418 keyboard matrix present"
        
      case 56
        print "I2C2 addr: 56 AHT20 temp & humidity sensor present"
        
      case 62
        print "I2C2 addr: 62 Onboard I2C LCD interface present"

      case 63
        print "I2C2 addr: 64 Onboard IO Expander present"

      case 94
        print "I2C2 addr: 94 TLV493D magnetometer present"

      case 98
        print "I2C2 addr: 98 MSA311 3-axis acceleratometer present"  
        
      case 104
        print "I2C2 addr: 104 RTC present"
     
      case else
        print "I2C2 addr:";n;" unknown device"
        
    end select

  End if
  pause 1
next n
